"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    var _a, _b, _c;
    try {
        if (op.id === 'ios.bundleId') {
            await ((_a = ctx.project.ios) === null || _a === void 0 ? void 0 : _a.setBundleId(op.iosTarget, op.iosBuild, op.value));
        }
        if (op.id === 'ios.displayName') {
            await ((_b = ctx.project.ios) === null || _b === void 0 ? void 0 : _b.setDisplayName(op.iosTarget, op.iosBuild, op.value));
        }
        if (op.id === 'ios.productName') {
            await ((_c = ctx.project.ios) === null || _c === void 0 ? void 0 : _c.setProductName(op.iosTarget, op.value));
        }
    }
    catch (e) {
        log_1.logger.warn(`Skipping ${op.id} (${e.message})`);
    }
}
exports.default = execute;
exports.OPS = [
    'ios.bundleId',
    'ios.displayName',
    'ios.productName'
];
//# sourceMappingURL=project.js.map