/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.b2c.api.core;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class NetworkManager {
    public static final String TAG = "NetworkManager";
    private int connectTimeout = 30000;
    private int readTimeout = 30000;
    private Proxy mProxy = null;
    private Context mContext;
    private boolean isCanceled = false;
    private static final String encoding = "UTF-8";

    public void cancel() {
        this.isCanceled = true;
    }

    public String SendAndWaitResponse(String strReqData, String strUrl) {
        String strResponse;
        block7: {
            this.detectProxy();
            strResponse = null;
            HttpURLConnection httpConnect = null;
            System.out.println(strUrl);
            System.out.println(strReqData);
            URL url = new URL(strUrl);
            httpConnect = this.mProxy != null ? (HttpURLConnection)url.openConnection(this.mProxy) : (HttpURLConnection)url.openConnection();
            httpConnect.setConnectTimeout(this.connectTimeout);
            httpConnect.setReadTimeout(this.readTimeout);
            httpConnect.setDoOutput(true);
            httpConnect.setDoInput(true);
            httpConnect.addRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            httpConnect.connect();
            OutputStream os = httpConnect.getOutputStream();
            os.write(strReqData.getBytes(encoding));
            os.flush();
            InputStream content = httpConnect.getInputStream();
            try {
                String string = NetworkManager.convertStreamToString(content);
                httpConnect.disconnect();
                return string;
            }
            catch (Exception e) {
                try {
                    try {
                        e.printStackTrace(System.out);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace(System.out);
                        httpConnect.disconnect();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    httpConnect.disconnect();
                    throw throwable;
                }
            }
            httpConnect.disconnect();
        }
        System.out.println(strResponse);
        return strResponse;
    }

    public NetworkManager(Context context) {
        this.mContext = context;
        this.setDefaultHostnameVerifier();
    }

    public static byte[] readByteArrayFromStream(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = -1;
        while ((length = inputStream.read(buffer)) > 0) {
            byteArrayOutputStream.write(buffer, 0, length);
        }
        byteArrayOutputStream.flush();
        inputStream.close();
        byte[] result = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return result;
    }

    public void detectProxy() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni != null && ni.isAvailable() && ni.getType() == 0) {
            String proxyHost = android.net.Proxy.getDefaultHost();
            int port = android.net.Proxy.getDefaultPort();
            if (proxyHost != null) {
                InetSocketAddress sa = new InetSocketAddress(proxyHost, port);
                this.mProxy = new Proxy(Proxy.Type.HTTP, sa);
            }
        }
    }

    private void setDefaultHostnameVerifier() {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    public String SendAndWaitResponse(String strUrl, String version, String plat, String ua) {
        this.detectProxy();
        String strResponse = null;
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("ver", version));
        pairs.add(new BasicNameValuePair("plat", plat));
        pairs.add(new BasicNameValuePair("ua", ua));
        HttpURLConnection httpConnect = null;
        try {
            try {
                UrlEncodedFormEntity p_entity = new UrlEncodedFormEntity(pairs, "utf-8");
                URL url = new URL(strUrl);
                url.getFile();
                httpConnect = this.mProxy != null ? (HttpURLConnection)url.openConnection(this.mProxy) : (HttpURLConnection)url.openConnection();
                httpConnect.setConnectTimeout(this.connectTimeout);
                httpConnect.setRequestMethod("GET");
                httpConnect.setReadTimeout(this.readTimeout);
                httpConnect.setDoOutput(true);
                httpConnect.addRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=utf-8");
                httpConnect.connect();
                OutputStream os = httpConnect.getOutputStream();
                p_entity.writeTo(os);
                os.flush();
                InputStream content = httpConnect.getInputStream();
                strResponse = NetworkManager.convertStreamToString(content);
                Log.d((String)TAG, (String)("response " + strResponse));
            }
            catch (IOException e) {
                e.printStackTrace();
                httpConnect.disconnect();
            }
        }
        finally {
            httpConnect.disconnect();
        }
        return strResponse;
    }

    public boolean urlDownloadToFile(Context context, String strurl, String path) {
        boolean bRet = false;
        this.detectProxy();
        HttpURLConnection conn = null;
        try {
            try {
                URL url = new URL(strurl);
                conn = this.mProxy != null ? (HttpURLConnection)url.openConnection(this.mProxy) : (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(this.connectTimeout);
                conn.setReadTimeout(this.readTimeout);
                conn.setDoInput(true);
                conn.connect();
                InputStream is = conn.getInputStream();
                File file = new File(path);
                file.createNewFile();
                FileOutputStream fos = new FileOutputStream(file);
                byte[] temp = new byte[1024];
                int i = 0;
                while ((i = is.read(temp)) > 0 && !this.isCanceled) {
                    fos.write(temp, 0, i);
                }
                fos.close();
                is.close();
                bRet = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (conn != null) {
                    conn.disconnect();
                    conn = null;
                }
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return bRet;
    }

    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

