/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImageUtil {
    public static float getScreenDensity(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        float screenDensity = dm.density;
        Log.v((String)"====", (String)("==" + screenDensity));
        return screenDensity;
    }

    public static Bitmap getImageFromAssetsFile(String fileName, Context context) {
        Bitmap image = null;
        AssetManager am = context.getResources().getAssets();
        try {
            InputStream is = am.open(fileName);
            image = BitmapFactory.decodeStream((InputStream)is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static Bitmap getImageFromAssetsFile(String fileName, Context context, int widght, int height) {
        Bitmap tem = ImageUtil.getImageFromAssetsFile(fileName, context);
        Bitmap image = Bitmap.createScaledBitmap((Bitmap)tem, (int)widght, (int)height, (boolean)true);
        tem.recycle();
        return image;
    }

    public static Drawable getDrawableFromAssetsFile(String fileName, Context context) {
        Drawable da = null;
        AssetManager am = context.getResources().getAssets();
        try {
            InputStream is = am.open(fileName);
            da = Drawable.createFromStream((InputStream)is, null);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return da;
    }

    public static StateListDrawable newSelector(Context context, String idNormal, String idPressed, String idFocused, String idUnable) {
        StateListDrawable bg = new StateListDrawable();
        Drawable normal = ImageUtil.getDrawableFromAssetsFile(idNormal, context);
        Drawable pressed = ImageUtil.getDrawableFromAssetsFile(idPressed, context);
        Drawable focused = ImageUtil.getDrawableFromAssetsFile(idFocused, context);
        Drawable unable = ImageUtil.getDrawableFromAssetsFile(idUnable, context);
        bg.addState(new int[]{16842919, 16842910}, pressed);
        bg.addState(new int[]{16842910, 16842908}, focused);
        bg.addState(new int[]{16842910}, normal);
        bg.addState(new int[]{16842908}, focused);
        bg.addState(new int[]{16842909}, unable);
        bg.addState(new int[0], normal);
        return bg;
    }

    private static Drawable getDrawableFromBitmap(Bitmap map) {
        BitmapDrawable draw = new BitmapDrawable(map);
        return draw.mutate();
    }

    public static boolean upgradeRootPermission(String pkgCodePath) {
        Process process = null;
        FilterOutputStream os = null;
        try {
            try {
                String cmd = "chmod 777 " + pkgCodePath;
                process = Runtime.getRuntime().exec("su");
                os = new DataOutputStream(process.getOutputStream());
                ((DataOutputStream)os).writeBytes(String.valueOf(cmd) + "\n");
                ((DataOutputStream)os).writeBytes("exit\n");
                ((DataOutputStream)os).flush();
                process.waitFor();
            }
            catch (Exception e) {
                try {
                    if (os != null) {
                        os.close();
                    }
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                process.destroy();
            }
            catch (Exception exception) {}
        }
        return true;
    }
}

