/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.util;

import android.content.Context;
import com.android.easou.epay.db.SharePreferUtil;
import com.android.easou.epay.util.EpayLog;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JudgeTimeUtil {
    public static boolean judgeTime(Context context) {
        long callInterval = SharePreferUtil.getCallInterval(context);
        long lastCallTime = SharePreferUtil.getLastCallTime(context);
        System.out.println("\u95f4\u9694=" + (System.currentTimeMillis() - lastCallTime));
        return System.currentTimeMillis() - lastCallTime > callInterval * 1000L || System.currentTimeMillis() < lastCallTime;
    }

    public static boolean judegFeeCallTime(Context context) {
        long lastCallTime = SharePreferUtil.getLastCallTime(context);
        int callCount = SharePreferUtil.getCallFeeCount(context);
        int maxCallCount = SharePreferUtil.getMaxCall(context);
        EpayLog.showSaveLog("====", "maxcount " + callCount + " , maxCall " + maxCallCount);
        int currentDay = JudgeTimeUtil.formatTime(System.currentTimeMillis(), 1);
        int lastCallDay = JudgeTimeUtil.formatTime(lastCallTime, 1);
        if (currentDay != lastCallDay) {
            SharePreferUtil.setCallFeeCount(context, 0);
            return true;
        }
        return callCount < maxCallCount;
    }

    public static boolean isMax(int type, Context context) {
        String timeCount = null;
        int maxMMCount = -1;
        int maxDDCount = -1;
        if (type == 0) {
            timeCount = SharePreferUtil.getIVRCount(context);
            maxMMCount = 500;
            maxDDCount = 100;
        } else if (type == 1) {
            timeCount = SharePreferUtil.getSMSCount(context);
            maxMMCount = 500;
            maxDDCount = 100;
        } else if (type == 2) {
            timeCount = SharePreferUtil.getWAPCount(context);
            maxMMCount = 500;
            maxDDCount = 100;
        }
        int mm = JudgeTimeUtil.formatTime(System.currentTimeMillis(), 0);
        int dd = JudgeTimeUtil.formatTime(System.currentTimeMillis(), 1);
        if (timeCount != null && !timeCount.trim().equals("")) {
            String[] timeCountArr = timeCount.split("_");
            int month = Integer.parseInt(timeCountArr[0].split(":")[0]);
            int day = Integer.parseInt(timeCountArr[0].split(":")[1]);
            int mmCount = Integer.parseInt(timeCountArr[1]);
            int ddCount = Integer.parseInt(timeCountArr[2]);
            if (mm != month) {
                String formatString = String.valueOf(mm) + ":" + dd + "_" + 1 + "_" + 1;
                JudgeTimeUtil.saveCount(type, context, formatString);
            } else if (dd != day) {
                if (mmCount < maxMMCount) {
                    String formatString = String.valueOf(mm) + ":" + dd + "_" + (mmCount + 1) + "_" + 1;
                    JudgeTimeUtil.saveCount(type, context, formatString);
                    return true;
                }
            } else if (mmCount <= maxMMCount && ddCount <= maxDDCount) {
                String formatString = String.valueOf(mm) + ":" + dd + "_" + (mmCount + 1) + "_" + (ddCount + 1);
                JudgeTimeUtil.saveCount(type, context, formatString);
                return true;
            }
        } else {
            String formatString = String.valueOf(mm) + ":" + dd + "_" + 1 + "_" + 1;
            JudgeTimeUtil.saveCount(type, context, formatString);
            return true;
        }
        EpayLog.showSaveLog("====", "timeCount is " + timeCount + ",\u8d85\u8fc7\u6700\u5927\u8c03\u7528\u6b21\u6570");
        return false;
    }

    public static void saveCount(int type, Context context, String formatString) {
        if (type == 0) {
            SharePreferUtil.setIVRCount(context, formatString);
        } else if (type == 1) {
            SharePreferUtil.setSMSCount(context, formatString);
        } else if (type == 2) {
            SharePreferUtil.setWAPCount(context, formatString);
        }
    }

    public static int formatTime(long time, int type) {
        String formatString = null;
        switch (type) {
            case 0: {
                formatString = "MM";
                break;
            }
            case 1: {
                formatString = "dd";
                break;
            }
            default: {
                formatString = "yy-MM-dd hh:mm:ss SSS";
            }
        }
        SimpleDateFormat form = new SimpleDateFormat(formatString);
        String tim = form.format(new Date(time));
        try {
            return Integer.parseInt(tim);
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

