/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.util;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import com.android.easou.epay.bean.EpayBean;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.SystemInfo;
import com.android.easou.epay.util.WifiManage;
import com.android.easou.epay.wap.NetManage;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MobileNetworkManage {
    public static final String OPEN_MOBILE_NETWORK = "com.sz5g.superaction.OPEN_MOBILE_NETWORK";
    public static final String CLOSE_MOBILE_NETWORK = "com.sz5g.superaction.CLOSE_MOBILE_NETWORK";
    public static final int WIFI_OPEN = 1;
    public static final int MOBILE_OPEN = 2;
    public static final int NONE_OPEN = 0;
    public static int currentNetworType = -1;
    public static final int MAX_RETRY_TIMES = 3;
    public static final int NETWORK_SLEEP_TIME = 1000;
    public static final int MAX_RECONNECT_TIMES = 10;
    private Context context;

    public MobileNetworkManage(Context context) {
        this.context = context;
    }

    public String getSIMCardType() {
        return SystemInfo.getCardType(this.context);
    }

    public boolean isMobileNetworkOpened() {
        String netWork = SystemInfo.getNetworkInfo(this.context);
        return !netWork.equals("unknow") && !netWork.equals("wifi");
    }

    public void openMobileNetwork() {
        Intent intent = new Intent(OPEN_MOBILE_NETWORK);
        this.context.sendBroadcast(intent);
    }

    public void closeMobileNetwork() {
        Intent intent = new Intent(CLOSE_MOBILE_NETWORK);
        this.context.sendBroadcast(intent);
    }

    public static void toggleMobileData(Context context, boolean enabled) {
        ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
        Class<?> conMgrClass = null;
        Field iConMgrField = null;
        Object iConMgr = null;
        Class<?> iConMgrClass = null;
        Method setMobileDataEnabledMethod = null;
        try {
            conMgrClass = Class.forName(conMgr.getClass().getName());
            iConMgrField = conMgrClass.getDeclaredField("mService");
            iConMgrField.setAccessible(true);
            iConMgr = iConMgrField.get(conMgr);
            iConMgrClass = Class.forName(iConMgr.getClass().getName());
            setMobileDataEnabledMethod = iConMgrClass.getDeclaredMethod("setMobileDataEnabled", Boolean.TYPE);
            setMobileDataEnabledMethod.setAccessible(true);
            setMobileDataEnabledMethod.invoke(iConMgr, enabled);
        }
        catch (ClassNotFoundException e) {
            EpayLog.showSaveLog("==", "ClassNotFoundException");
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            EpayLog.showSaveLog("==", "NoSuchFieldException");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            EpayLog.showSaveLog("==", "SecurityException");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            EpayLog.showSaveLog("==", "NoSuchMethodException");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            EpayLog.showSaveLog("==", "IllegalArgumentException");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            EpayLog.showSaveLog("==", "IllegalAccessException");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            EpayLog.showSaveLog("==", "InvocationTargetException");
            e.printStackTrace();
        }
    }

    public static boolean initFee(Context context) {
        if (currentNetworType != -1) {
            return true;
        }
        EpayLog.showSaveLog("startWFee", "\u521d\u59cb\u5316\u7f51\u7edc....");
        WifiManage wifiManage = new WifiManage(context);
        NetManage netManage = new NetManage(context);
        if (!wifiManage.isWifiManageEnable()) {
            if (!netManage.isDataConnected()) {
                EpayLog.showSaveLog("startWFee", "\u79fb\u52a8\u7f51\u7edc\u6ca1\u6709\u6253\u5f00\uff0c\u6b63\u5728\u6253\u5f00\u79fb\u52a8\u7f51\u7edc....");
                MobileNetworkManage.toggleMobileData(context, true);
                if (currentNetworType != 1) {
                    currentNetworType = 0;
                }
            }
            if (!netManage.isCurrentWapAPN()) {
                EpayLog.showSaveLog("startFee", "set WAP");
                return netManage.setWapNetWork();
            }
            EpayLog.showSaveLog("startFee", "current is WAP");
            return true;
        }
        return false;
    }

    public static void recoverNetWork(Context context) {
        if (EpayBean.IVR_FEEING || EpayBean.SMS_FEEING || EpayBean.MMS_FEEING || EpayBean.WAP_FEEING) {
            EpayLog.showSaveLog("===", "IVR_FEEING " + EpayBean.IVR_FEEING + " , SMS_FEEING " + EpayBean.SMS_FEEING + " , MMS_FEEING " + EpayBean.MMS_FEEING + " , WAP_FEEING " + EpayBean.WAP_FEEING);
            return;
        }
        MobileNetworkManage.recoverNetWorkDir(context);
    }

    public static void recoverNetWorkDir(Context context) {
        if (currentNetworType != -1) {
            EpayLog.showSaveLog("", "\u5f00\u59cb\u6062\u590d\u7f51\u7edc\uff1a" + currentNetworType);
            WifiManage wifiManage = new WifiManage(context);
            switch (currentNetworType) {
                case 1: {
                    wifiManage.OpenWifi();
                    break;
                }
                case 2: {
                    wifiManage.CloseWifi();
                    MobileNetworkManage.toggleMobileData(context, true);
                    break;
                }
                case 0: {
                    wifiManage.CloseWifi();
                    MobileNetworkManage.toggleMobileData(context, false);
                    break;
                }
            }
            currentNetworType = -1;
        }
    }
}

