/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.android.easou.epay.bean.IVRBean;
import com.android.easou.epay.db.EPayDBHelper;
import java.util.LinkedList;
import java.util.List;

public class IVRDBManager {
    private static IVRDBManager manager;

    private IVRDBManager() {
    }

    public static IVRDBManager getInstance() {
        if (manager == null) {
            manager = new IVRDBManager();
        }
        return manager;
    }

    public void insertIVR(IVRBean ivr, Context context) {
        SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("port", ivr.getPort());
        values.put("sms_delay_time", Integer.valueOf(ivr.getCallTime()));
        values.put("filter_info", ivr.getFilterInfo());
        values.put("filter_port", ivr.getFilterPort());
        db.insert("ivr", null, values);
        db.close();
    }

    public void deleteAllIVR(Context context) {
        SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
        db.delete("ivr", null, null);
        db.close();
    }

    public void deleteIVRById(Context context, int id) {
        SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
        db.delete("ivr", "_ID = ? ", new String[]{String.valueOf(id)});
        db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IVRBean> getAllIVRBean(Context context) {
        String string = "lock";
        synchronized ("lock") {
            LinkedList<IVRBean> allIVRBean = new LinkedList<IVRBean>();
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getReadableDatabase();
            StringBuffer sql = new StringBuffer();
            sql.append(" select ").append("_ID").append(" , ").append("port").append(" , ").append("sms_delay_time").append(" , ").append("filter_info").append(" , ").append("filter_port").append(" from ").append("ivr");
            Cursor cursor = db.rawQuery(sql.toString(), null);
            cursor.moveToFirst();
            if (cursor.getCount() >= 1) {
                do {
                    IVRBean ivr = new IVRBean();
                    ivr.setId(cursor.getInt(0));
                    ivr.setPort(cursor.getString(1));
                    ivr.setCallTime(cursor.getInt(2));
                    ivr.setFilterInfo(cursor.getString(3));
                    ivr.setFilterPort(cursor.getString(4));
                    allIVRBean.add(ivr);
                } while (cursor.moveToNext());
            }
            cursor.close();
            db.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return allIVRBean;
        }
    }
}

