/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.db;

import android.content.Context;
import android.content.SharedPreferences;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.SystemInfo;

public class SharePreferUtil {
    private static final String EPAY_SHARE = "epay_share";
    private static final String SMS_COUNT = "sms_count";
    private static final String CALL_FEE_COUNT = "call_fee_count";
    private static final String SMSC = "smsc-";
    private static final String IVR_COUNT = "ivr_count";
    private static final String WAP_COUNT = "wap_count";
    private static final String BACK_URL = "back_url";
    private static final String MOBILE = "mobile-";
    private static final String BACK_JWD = "back_jwd";
    private static final String USER_ID = "user_id";

    public static long getLastCallTime(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getLong("last_call_time", -1L);
    }

    public static void setLastCallTime(Context context, long inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong("last_call_time", inited);
        editor.commit();
    }

    public static int getCallInterval(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getInt("call_interval", 10);
    }

    public static void setCallInterval(Context context, int inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("call_interval", inited);
        editor.commit();
    }

    public static int getMaxCall(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getInt("call_max", 10);
    }

    public static void setMaxCall(Context context, int inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("call_max", inited);
        editor.commit();
    }

    public static String getFee(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString("fee", "10\u5143");
    }

    public static void setFee(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("fee", inited);
        editor.commit();
    }

    public static int getFeeType(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getInt("fee_type", 10);
    }

    public static void setFeeType(Context context, int inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("fee_type", inited);
        editor.commit();
    }

    public static int getIsPOP(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getInt("is_pop", 10);
    }

    public static void setIsPOP(Context context, int inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("is_pop", inited);
        editor.commit();
    }

    public static String getProdName(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString("prod_name", "");
    }

    public static void setProdName(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("prod_name", inited);
        editor.commit();
    }

    public static String getSuppName(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString("supp_name", "");
    }

    public static void setSuppName(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("supp_name", inited);
        editor.commit();
    }

    public static String getSMSCount(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString(SMS_COUNT, "");
    }

    public static void setSMSCount(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(SMS_COUNT, inited);
        editor.commit();
    }

    public static int getCallFeeCount(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getInt(CALL_FEE_COUNT, 0);
    }

    public static void setCallFeeCount(Context context, int inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(CALL_FEE_COUNT, inited);
        editor.commit();
    }

    public static void saveSMSCToDataBase(String smsc, Context context) {
        try {
            SharedPreferences preference = context.getSharedPreferences(EPAY_SHARE, 0);
            SharedPreferences.Editor edit = preference.edit();
            edit.putString(SMSC + SystemInfo.getIMSI(context), smsc);
            edit.commit();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static String getSMSCFromDataBase(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString(SMSC + SystemInfo.getIMSI(context), null);
    }

    public static String getIVRCount(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString(IVR_COUNT, "");
    }

    public static void setIVRCount(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(IVR_COUNT, inited);
        editor.commit();
    }

    public static String getWAPCount(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString(WAP_COUNT, "");
    }

    public static void setWAPCount(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(WAP_COUNT, inited);
        editor.commit();
    }

    public static String getBACK_URL(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString(BACK_URL, "");
    }

    public static void setBACK_URL(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(BACK_URL, inited);
        editor.commit();
    }

    public static void saveMOBILEToDataBase(String smsc, Context context) {
        try {
            SharedPreferences preference = context.getSharedPreferences(EPAY_SHARE, 0);
            SharedPreferences.Editor edit = preference.edit();
            edit.putString(MOBILE + SystemInfo.getIMSI(context), smsc);
            EpayLog.showSaveLog("===", MOBILE + SystemInfo.getIMSI(context) + "===" + smsc);
            edit.commit();
        }
        catch (SecurityException e) {
            EpayLog.showSaveLog("===", e.getMessage());
        }
    }

    public static String getMOBILEFromDataBase(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        String res = sp.getString(MOBILE + SystemInfo.getIMSI(context), null);
        EpayLog.showSaveLog("===", MOBILE + SystemInfo.getIMSI(context) + "===" + res);
        return res;
    }

    public static String getBACK_JWD(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString(BACK_JWD, "");
    }

    public static void setBACK_JWD(Context context, String inited) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(BACK_JWD, inited);
        editor.commit();
    }

    public static String getUSER_ID(Context context) {
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 1);
        return sp.getString(USER_ID, "");
    }

    public static void setUSER_ID(Context context, String inited) {
        EpayLog.showSaveLog("===", inited);
        SharedPreferences sp = context.getSharedPreferences(EPAY_SHARE, 2);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(USER_ID, inited);
        editor.commit();
    }
}

