/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.ui;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.easou.epay.util.ImageUtil;

public class LoadingView
extends RelativeLayout {
    private TextView hintText;
    private ImageView loadingImage;
    private RotateAnimation rotateAni;
    private RelativeLayout waitingLayout;

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.waitingLayout = new RelativeLayout(this.getContext(), null);
        this.waitingLayout.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("epay_pic/background.png", this.getContext()));
        int feeWid = (int)(300.0f * ImageUtil.getScreenDensity(this.getContext()));
        int feeHei = (int)(300.0f * ImageUtil.getScreenDensity(this.getContext()));
        int feeMar = (int)(10.0f * ImageUtil.getScreenDensity(this.getContext()));
        RelativeLayout.LayoutParams feeParams = new RelativeLayout.LayoutParams(feeWid, feeHei);
        feeParams.addRule(13, 13);
        this.waitingLayout.setId(1000);
        this.addView((View)this.waitingLayout, (ViewGroup.LayoutParams)feeParams);
        this.rotateAni = new RotateAnimation(359.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.rotateAni.setDuration(500L);
        this.rotateAni.setRepeatMode(1);
        LinearInterpolator lin = new LinearInterpolator();
        this.rotateAni.setInterpolator((Interpolator)lin);
        this.rotateAni.setRepeatCount(-1);
        this.rotateAni.setFillAfter(false);
        int produWid = (int)(96.0f * ImageUtil.getScreenDensity(this.getContext()));
        int produHei = (int)(96.0f * ImageUtil.getScreenDensity(this.getContext()));
        this.setBackgroundColor(Color.argb((int)51, (int)0, (int)0, (int)0));
        RelativeLayout.LayoutParams progressParams = new RelativeLayout.LayoutParams(produWid, produHei);
        progressParams.addRule(13, -1);
        this.loadingImage = new ImageView(this.getContext());
        this.loadingImage.setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("epay_pic/loading.png", this.getContext()));
        this.loadingImage.setId(3000);
        this.loadingImage.startAnimation((Animation)this.rotateAni);
        this.waitingLayout.addView((View)this.loadingImage, (ViewGroup.LayoutParams)progressParams);
        RelativeLayout.LayoutParams produFeeTextParams = new RelativeLayout.LayoutParams(-2, -2);
        produFeeTextParams.addRule(14, -1);
        produFeeTextParams.addRule(3, this.loadingImage.getId());
        this.hintText = new TextView(this.getContext());
        this.hintText.setId(3001);
        this.hintText.setTextSize(20.0f);
        this.hintText.setTextColor(-16711936);
        this.hintText.setText((CharSequence)"\u8bf7\u7a0d\u7b49...");
        this.waitingLayout.addView((View)this.hintText, (ViewGroup.LayoutParams)produFeeTextParams);
    }
}

