/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import android.util.Xml;
import com.android.easou.epay.sms.SMSCTools;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.FileUtil;
import com.android.easou.epay.util.KeyValue;
import com.android.easou.epay.util.SystemInfo;
import com.android.easou.epay.wap.EpayHeader;
import com.android.easou.epay.wap.GameFee;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.xmlpull.v1.XmlPullParser;

public class Tools {
    private static boolean saveLog = true;
    private static boolean showLog = true;
    private static FileWriter fWriter = null;
    private static String saveLogPath = "/sdcard/Platform-Log.txt";
    private static final String SMSCountShare = "SMSCountShare";
    private static final String MONTH = "month";
    private static final String COUNT = "count";
    private static int[] moneyArr = new int[]{10, 20, 30, 50, 100, 300, 500};

    public static void setShowLog(boolean bool) {
        showLog = bool;
    }

    public static void showLog(String tag, String msg) {
        if (showLog) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void showSaveLog(String tag, String msg) {
        if (showLog) {
            Log.e((String)tag, (String)msg);
        }
        if (saveLog) {
            try {
                if (fWriter == null) {
                    fWriter = new FileWriter(saveLogPath, true);
                }
                if (tag != null && msg != null) {
                    tag = String.valueOf(tag) + ":";
                    if (msg.length() >= 100) {
                        tag = String.valueOf(tag) + "\r\n";
                    }
                    fWriter.write(String.valueOf(tag) + msg + "\r\n");
                    fWriter.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSaveLog() {
        try {
            if (fWriter != null) {
                fWriter.close();
                fWriter = null;
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAppInstalled(Context context, String packageName) {
        if (packageName == null || packageName.trim().equals("")) {
            return false;
        }
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName, 8192);
            return info != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static void saveLog(String str, String savePath, boolean append) {
        if (saveLog) {
            FileWriter fWriter = null;
            try {
                fWriter = new FileWriter(savePath, append);
                if (fWriter != null) {
                    fWriter.write(str);
                    fWriter.flush();
                    fWriter.close();
                    fWriter = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void saveFile(String str, String savePath, boolean append) {
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(savePath, append);
            if (fWriter != null) {
                fWriter.write(str);
                fWriter.flush();
                fWriter.close();
                fWriter = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        int i = 0;
        while (i < len) {
            int pos = i * 2;
            result[i] = (byte)(Tools.toByte(achar[pos]) << 4 | Tools.toByte(achar[pos + 1]));
            ++i;
        }
        return result;
    }

    private static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    private static final String bytesToHexString(byte[] bArray) {
        if (bArray == null) {
            return null;
        }
        if (bArray.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bArray.length * 2);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static final String toHex(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return Tools.bytesToHexString(str.getBytes());
    }

    public static final String fromHex(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return new String(Tools.hexStringToByte(str));
    }

    public static final String fromHex(String str, String charset) {
        if (str == null || str.equals("")) {
            return str;
        }
        try {
            return new String(Tools.hexStringToByte(str), charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(Tools.hexStringToByte(str));
        }
    }

    public static void printStackTrace(String log_tag, StackTraceElement[] stack) {
        StackTraceElement[] stackTraceElementArray = stack;
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            Log.e((String)log_tag, (String)("\tat " + element));
            ++n2;
        }
    }

    public static List<String> getStringFromHeader(InputStream header) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(header));
        String tem = null;
        try {
            while ((tem = br.readLine()) != null) {
                list.add(Tools.fromHex(tem));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void updateSMSCount(Context context) {
        int count = 0;
        SharedPreferences pre = context.getSharedPreferences(SMSCountShare, 2);
        SharedPreferences.Editor edit = pre.edit();
        String lastMonth = pre.getString(MONTH, null);
        String thisMonth = Tools.getCurrentDate("yyyy-MM", null);
        if (lastMonth != null && lastMonth.equals(lastMonth)) {
            count = pre.getInt(COUNT, 0) + 1;
            edit.putInt(COUNT, count);
        } else {
            edit.putString(MONTH, thisMonth);
            edit.putInt(COUNT, ++count);
        }
        Log.e((String)"cont", (String)("count is " + count + ", month is " + thisMonth));
        edit.commit();
    }

    public static int getSMSCount(Context context) {
        SharedPreferences pre = context.getSharedPreferences(SMSCountShare, 2);
        int count = pre.getInt(COUNT, 0);
        return count;
    }

    public static String getSubString(String str, int length) {
        if (str == null || length < 0 || str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    private static HttpResponse getUrl(HttpClient client, String url, ArrayList<KeyValue> headerList) {
        int i;
        Log.e((String)"Tools-getUrl", (String)("GET:" + url));
        HttpResponse response = null;
        String xHost = null;
        HttpGet httpGet = null;
        try {
            httpGet = new HttpGet(url);
            if (headerList != null && headerList.size() > 0) {
                i = 0;
                while (i < headerList.size()) {
                    String keyTemp;
                    KeyValue keyValue = headerList.get(i);
                    if (keyValue != null && !(keyTemp = keyValue.getKey().toLowerCase()).equals("content-length") && !keyTemp.equals("host")) {
                        httpGet.setHeader(keyValue.getKey(), keyValue.getValue());
                    }
                    ++i;
                }
            }
            httpGet.setHeader("Host", "10.0.0.172");
            httpGet.setHeader("X-Online-Host", xHost);
            if (httpGet.getFirstHeader("Range") == null) {
                httpGet.setHeader("Range", "bytes=0-199999");
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (httpGet != null) {
            Header[] headerlist = httpGet.getAllHeaders();
            if (headerlist != null && headerlist.length > 0) {
                i = 0;
                while (i < headerlist.length) {
                    Log.e((String)"Tools-getUrl", (String)(String.valueOf(headerlist[i].getName()) + ": " + headerlist[i].getValue()));
                    ++i;
                }
            } else {
                Log.e((String)"Tools-getUrl", (String)"headerlist is null");
            }
            i = 0;
            while (i < 10) {
                try {
                    response = client.execute((HttpUriRequest)httpGet);
                }
                catch (ClientProtocolException e) {
                    response = null;
                }
                catch (IOException e) {
                    response = null;
                }
                catch (Exception e) {
                    response = null;
                }
                if (response != null && response.getStatusLine() != null) {
                    int stateCode = response.getStatusLine().getStatusCode();
                    Log.e((String)"requestSubUrl", (String)("GET " + url + " StatusCode:" + stateCode));
                    if (stateCode == 200 || stateCode == 206 || stateCode == 302) {
                        return response;
                    }
                } else {
                    httpGet.abort();
                }
                ++i;
            }
        }
        return null;
    }

    private static HttpResponse postUrl(HttpClient client, String url, ArrayList<KeyValue> headerList, String body) {
        int i;
        Log.e((String)"Tools-postUrl", (String)("POST:" + url));
        HttpResponse response = null;
        String xHost = null;
        if (url.toLowerCase().startsWith("http://")) {
            xHost = Tools.subString(url = "http://" + url.substring(7), "http://", null, "/", 0);
            if (xHost == null && (xHost = Tools.subString(url, "http://", 0, "?", 0)) == null) {
                xHost = url.substring(7);
            }
        } else if (url.toLowerCase().startsWith("www.") && (xHost = Tools.subString(url = "www." + url.substring(4), "www.", 0, "/", 0)) == null && (xHost = Tools.subString(url, "www.", 0, "?", 0)) == null) {
            xHost = url.substring(4);
        }
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(url);
            if (headerList != null && headerList.size() > 0) {
                i = 0;
                while (i < headerList.size()) {
                    String keyTemp;
                    KeyValue keyValue = headerList.get(i);
                    if (keyValue != null && !(keyTemp = keyValue.getKey().toLowerCase()).equals("content-length") && !keyTemp.equals("host")) {
                        httpPost.setHeader(keyValue.getKey(), keyValue.getValue());
                    }
                    ++i;
                }
            }
            httpPost.setHeader("Host", "10.0.0.172");
            httpPost.setHeader("X-Online-Host", xHost);
            if (httpPost.getFirstHeader("Range") == null) {
                httpPost.setHeader("Range", "bytes=0-199999");
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (httpPost != null) {
            Header[] headerlist = httpPost.getAllHeaders();
            if (headerlist != null && headerlist.length > 0) {
                i = 0;
                while (i < headerlist.length) {
                    Log.e((String)"Tools-postUrl", (String)(String.valueOf(headerlist[i].getName()) + ": " + headerlist[i].getValue()));
                    ++i;
                }
            } else {
                Log.e((String)"Tools-postUrl", (String)"headerlist is null");
            }
            if (body != null && !body.equals("")) {
                try {
                    httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
                }
                catch (UnsupportedEncodingException i2) {
                    // empty catch block
                }
            }
            int i3 = 0;
            while (i3 < 10) {
                try {
                    response = client.execute((HttpUriRequest)httpPost);
                }
                catch (ClientProtocolException e) {
                    response = null;
                }
                catch (IOException e) {
                    response = null;
                }
                catch (Exception e) {
                    response = null;
                }
                if (response != null && response.getStatusLine() != null) {
                    int stateCode = response.getStatusLine().getStatusCode();
                    Log.e((String)"requestSubUrl", (String)("POST " + url + " StatusCode:" + stateCode));
                    if (stateCode == 200 || stateCode == 206 || stateCode == 302) {
                        return response;
                    }
                } else {
                    httpPost.abort();
                }
                ++i3;
            }
        }
        return null;
    }

    public static HttpResponse requestSubUrl(String subUrl, boolean isPost, ArrayList<KeyValue> headerList, String body) {
        if (subUrl == null || subUrl.trim().equals("")) {
            return null;
        }
        subUrl = Tools.replaceSpecialChar(subUrl);
        Log.e((String)"requestSubUrl", (String)(String.valueOf(isPost ? "POST " : "GET ") + subUrl));
        HttpHost proxy = new HttpHost("10.0.0.172", 80);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams httpParams = client.getParams();
        httpParams.setParameter("http.route.default-proxy", (Object)proxy);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)600000);
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        if (!isPost) {
            return Tools.getUrl((HttpClient)client, subUrl, headerList);
        }
        return Tools.postUrl((HttpClient)client, subUrl, headerList, body);
    }

    public static HttpResponse postURL(boolean wifi, String url, ArrayList<KeyValue> headerList, String body) {
        int i;
        if (url == null || url.trim().equals("")) {
            return null;
        }
        url = Tools.replaceSpecialChar(url);
        Log.e((String)"requestSubUrl", (String)("POST " + url));
        HttpHost proxy = null;
        if (!wifi) {
            String defaultHost = Proxy.getDefaultHost();
            int defaultPort = Proxy.getDefaultPort();
            if (defaultHost != null && defaultPort != -1) {
                proxy = new HttpHost(defaultHost, defaultPort);
            }
            Log.e((String)"postURL", (String)("defaultHost=" + defaultHost + " defaultPort=" + defaultPort));
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams httpParams = client.getParams();
        if (proxy != null) {
            httpParams.setParameter("http.route.default-proxy", proxy);
        }
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)600000);
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)true);
        Log.e((String)"Tools-postUrl", (String)("POST:" + url));
        HttpResponse response = null;
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(url);
            if (headerList != null && headerList.size() > 0) {
                i = 0;
                while (i < headerList.size()) {
                    String keyTemp;
                    KeyValue keyValue = headerList.get(i);
                    if (keyValue != null && !(keyTemp = keyValue.getKey().toLowerCase()).equals("content-length")) {
                        httpPost.setHeader(keyValue.getKey(), keyValue.getValue());
                    }
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (httpPost != null) {
            Header[] headerlist = httpPost.getAllHeaders();
            if (headerlist != null && headerlist.length > 0) {
                i = 0;
                while (i < headerlist.length) {
                    Log.e((String)"Tools-postUrl", (String)(String.valueOf(headerlist[i].getName()) + ": " + headerlist[i].getValue()));
                    ++i;
                }
            } else {
                Log.e((String)"Tools-postUrl", (String)"headerlist is null");
            }
            if (body != null && !body.equals("")) {
                try {
                    httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
                }
                catch (UnsupportedEncodingException i2) {
                    // empty catch block
                }
            }
            int i3 = 0;
            while (i3 < 10) {
                try {
                    response = client.execute((HttpUriRequest)httpPost);
                }
                catch (ClientProtocolException e) {
                    response = null;
                }
                catch (IOException e) {
                    response = null;
                }
                catch (Exception e) {
                    response = null;
                }
                if (response != null && response.getStatusLine() != null) {
                    int stateCode = response.getStatusLine().getStatusCode();
                    Log.e((String)"requestSubUrl", (String)("POST " + url + " StatusCode:" + stateCode));
                    if (stateCode == 200 || stateCode == 206 || stateCode == 302) {
                        return response;
                    }
                } else {
                    httpPost.abort();
                }
                ++i3;
            }
        }
        return null;
    }

    public static String getHeader(HttpResponse response) {
        String header = null;
        if (response != null) {
            Header[] headers = response.getAllHeaders();
            StringBuffer sb = new StringBuffer();
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header tem = headerArray[n2];
                sb.append(tem + "\r\n");
                ++n2;
            }
            header = sb.toString();
        }
        return header;
    }

    public static String getBody(HttpResponse response, Context context) {
        Header[] header = response.getAllHeaders();
        if (header != null && header.length > 0) {
            Header[] headerArray = header;
            int n = header.length;
            int n2 = 0;
            while (n2 < n) {
                Header her = headerArray[n2];
                EpayLog.showSaveLog("===", String.valueOf(her.getName()) + " , " + her.getValue());
                if (her.getName().trim().equals("Content-Type") && her.getValue().trim().contains("audio/mpeg")) {
                    try {
                        FileUtil.saveFlashFile(response.getEntity().getContent(), String.valueOf(FileUtil.getExterPath()) + "/" + System.currentTimeMillis() + ".mp3");
                        FileUtil.deleteEpayFile(FileUtil.getExterPath());
                        Tools.submitConfirm(context, 5, 0);
                        return "\u97f3\u4e50\u7c7b\u578b\uff0c\u4e0b\u8f7d\u5230SDCARD";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EpayLog.showSaveLog("===", String.valueOf(e.getMessage()) + e.getStackTrace());
                    }
                } else if (her.getName().trim().equals("Content-Type") && her.getValue().trim().contains("video/3gpp")) {
                    try {
                        FileUtil.saveFlashFile(response.getEntity().getContent(), String.valueOf(FileUtil.getExterPath()) + "/" + System.currentTimeMillis() + ".3gp");
                        FileUtil.deleteEpayFile(FileUtil.getExterPath());
                        Tools.submitConfirm(context, 4, 0);
                        return "\u89c6\u9891\u7c7b\u578b\uff0c\u4e0b\u8f7d\u5230SDCARD";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EpayLog.showSaveLog("===", String.valueOf(e.getMessage()) + e.getStackTrace());
                    }
                }
                ++n2;
            }
        }
        try {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            EpayLog.showSaveLog("====", e.getMessage());
            return null;
        }
    }

    public static String getBody(HttpEntity entity) {
        try {
            EpayLog.showSaveLog("====", "\u5904\u7406entit" + entity);
            EpayLog.showSaveLog("====", String.valueOf(entity.getContentLength()));
            String result = EntityUtils.toString((HttpEntity)entity);
            return result;
        }
        catch (Exception e) {
            EpayLog.showSaveLog("====", "\u5904\u7406entity\u9519\u8bef" + entity + " , " + e.getMessage() + " , " + e.getStackTrace());
            return null;
        }
    }

    public static byte[] readFile(String path) {
        byte[] data = null;
        try {
            FileInputStream fin = new FileInputStream(path);
            int length = fin.available();
            if (length > 0) {
                data = new byte[length];
                int k = 1024;
                int start = 0;
                while (start < length) {
                    k = length - start;
                    if (k >= 1024) {
                        k = 1024;
                    }
                    fin.read(data, start, k);
                    start += k;
                }
            }
            fin.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    public static String replaceSpecialChar(String str) {
        if (str == null || str.trim().equals("")) {
            return str;
        }
        String[] source = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;", "&nbsp;"};
        String[] replace = new String[]{"<", ">", "&", "'", "\"", " "};
        int i = 0;
        while (i < source.length) {
            str = str.replaceAll(source[i], replace[i]);
            ++i;
        }
        return str;
    }

    public static String subString(String source, String start, Integer startInc, String end, Integer endInc) {
        String result = null;
        if (source == null || start == null || end == null) {
            return result;
        }
        if (startInc == null) {
            startInc = start.length();
        }
        if (endInc == null) {
            endInc = end.length();
        }
        int index1 = source.indexOf(start);
        int index2 = 0;
        if (index1 >= 0) {
            index2 = source.indexOf(end, index1 += startInc.intValue());
            int length = source.length();
            if (index1 >= 0 && (index2 += endInc.intValue()) <= length && index2 > index1) {
                result = source.substring(index1, index2);
            } else if (index1 == index2) {
                result = "";
            }
        }
        return result;
    }

    public static String replaceAll(String source, String subStr, String newStr) {
        if (source == null || source.equals("") || subStr == null || subStr.equals("")) {
            return source;
        }
        int begin = 0;
        int index = source.indexOf(subStr, begin);
        while (index >= 0) {
            source = String.valueOf(source.substring(0, index)) + newStr + source.substring(index + subStr.length());
            index = source.indexOf(subStr);
        }
        return source;
    }

    public static String getCurrentDate(String format, Date date) {
        if (format == null) {
            format = "yyyy-MM-dd";
        }
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String getCurrentTimeInfo() {
        Date date = new Date();
        return " [time:<" + Tools.getCurrentDate("yyyy-MM-dd HH:mm:ss", date) + "> And Millis:<" + date.getTime() + ">] ";
    }

    public static boolean isPhoneNumberValid(String mobiles) {
        if (mobiles == null || mobiles.trim().equals("")) {
            return false;
        }
        if (mobiles.startsWith("+86")) {
            mobiles = mobiles.substring(3);
        }
        if (mobiles.length() != 11) {
            return false;
        }
        Pattern p = Pattern.compile("^([1][3-9])\\d{9}$");
        Matcher m = p.matcher(mobiles);
        return m.matches();
    }

    public static int[] getAllCardMoney() {
        return moneyArr;
    }

    public static boolean isEffectMoney(int money) {
        int i = 0;
        while (i < moneyArr.length) {
            if (money < moneyArr[i]) {
                return false;
            }
            if (money == moneyArr[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAllNumberString(String str, Integer minNum, Integer maxNum) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        if (minNum == null) {
            minNum = 0;
        }
        String patternStr = "\\d{" + minNum + ",";
        if (maxNum != null) {
            patternStr = String.valueOf(patternStr) + maxNum;
        }
        patternStr = String.valueOf(patternStr) + "}";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static ArrayList<KeyValue> getHeaderList(Context context) {
        ArrayList<KeyValue> headerList = new ArrayList<KeyValue>();
        headerList.add(new KeyValue("MID", SystemInfo.getMID(context)));
        headerList.add(new KeyValue("MIDX", SystemInfo.getMID(context)));
        headerList.add(new KeyValue("softversion", ""));
        headerList.add(new KeyValue("LAC", SystemInfo.getLAC(context)));
        headerList.add(new KeyValue("IMEI", SystemInfo.getIMEI(context)));
        headerList.add(new KeyValue("BT", SystemInfo.getBT(context)));
        headerList.add(new KeyValue("Screen", SystemInfo.getScreen(context)));
        headerList.add(new KeyValue("CardType", SystemInfo.getCardType(context)));
        headerList.add(new KeyValue("Network", SystemInfo.getNetworkInfo(context)));
        return headerList;
    }

    public static String getDefaultGETHeader() {
        return "HTTP/1.1 200 OK\r\nHost: download.cmgame.com\r\nUser-Agent: NokiaN73-1/4.0850.43.1.1 Series60/3.0 Profile/MIDP-2.0 Configuration/CLDC-1.1\r\nAccept: application/vnd.wap.wmlscriptc, text/vnd.wap.wml, application/vnd.wap.xhtml+xml, application/xhtml+xml, text/html, multipart/mixed, */*, text/x-vcard, text/x-vcalendar, image/gif, image/vnd.wap.wbmp\r\nAccept-Language: zh-CN\r\nAccept-Charset: ISO-8859-1, US-ASCII, UTF-8; Q=0.8, ISO-10646-UCS-2; Q=0.6\r\n\r\n";
    }

    public static String getDefaultPOSTHeader() {
        return "HTTP/1.1 200 OK\r\nHost: download.cmgame.com\r\nUser-Agent: NokiaN73-1/4.0850.43.1.1 Series60/3.0 Profile/MIDP-2.0 Configuration/CLDC-1.1\r\nAccept: application/vnd.wap.wmlscriptc, text/vnd.wap.wml, application/vnd.wap.xhtml+xml, application/xhtml+xml, text/html, multipart/mixed, */*, text/x-vcard, text/x-vcalendar, image/gif, image/vnd.wap.wbmp\r\nAccept-Language: zh-CN\r\nAccept-Charset: ISO-8859-1, US-ASCII, UTF-8; Q=0.8, ISO-10646-UCS-2; Q=0.6\r\nContent-Type: text/plain\r\nConnection: close\r\nContent-Length: 0\r\n\r\n";
    }

    public static HttpResponse getContentByCMWAP(String url, Header[] headers, Context context) {
        HttpResponse rsp = null;
        try {
            EpayLog.showSaveLog("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a " + url);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet req = new HttpGet(url);
            if (Tools.isNeedProxy(context)) {
                HttpHost proxy = new HttpHost(Proxy.getDefaultHost(), Proxy.getDefaultPort(), "http");
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                req.setHeader("accept", "text/vnd.wap.wml");
            }
            EpayLog.showSaveLog("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a00\uff01");
            if (headers != null) {
                req.setHeaders(headers);
            }
            rsp = httpclient.execute((HttpUriRequest)req);
            EpayLog.showSaveLog("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a11\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            EpayLog.showSaveLog("===", String.valueOf(e.getMessage()) + "\u83b7\u53d6\u534f\u8bae\u5f02\u5e38\uff01");
        }
        EpayLog.showSaveLog("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a\u7ed3\u675f\uff01");
        return rsp;
    }

    public static boolean isNeedProxy(Context context) {
        block4: {
            ConnectivityManager conManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo network = conManager.getActiveNetworkInfo();
            if (network == null || network.getType() != 1) break block4;
            return false;
        }
        try {
            String proxyHost = Proxy.getDefaultHost();
            if (proxyHost != null && !proxyHost.equals("")) {
                EpayLog.showSaveLog("info", "\u4f7f\u7528\u4ee3\u7406");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void showAllHeader(Header[] allHeader, List<EpayHeader> header) {
        if (header == null) {
            header = new ArrayList<EpayHeader>();
        } else {
            header.clear();
        }
        Header[] headerArray = allHeader;
        int n = allHeader.length;
        int n2 = 0;
        while (n2 < n) {
            Header tem = headerArray[n2];
            EpayLog.showSaveLog("header ", String.valueOf(tem.getName()) + " , " + tem.getValue());
            ++n2;
        }
    }

    public static List<String> getURLByResponse(String url, HttpResponse response) {
        HttpResponse rsp = null;
        try {
            EpayLog.showSaveLog("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a " + url);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpHost proxy = new HttpHost("10.0.0.172", 80, "http");
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            ArrayList formparams = new ArrayList();
            HttpPost request = new HttpPost(url);
            request.setEntity(response.getEntity());
            request.setHeaders(response.getAllHeaders());
            rsp = httpclient.execute((HttpUriRequest)request);
            httpclient.getConnectionManager().shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            EpayLog.showSaveLog("===", String.valueOf(e.getMessage()) + e.getStackTrace());
        }
        return null;
    }

    public static List<String> getResultByMethod(String source, String method, String include, String an_include, int urlNum, String addUrl) {
        ArrayList<String> result = new ArrayList<String>();
        if (source == null || method == null || source.trim().equals("") || method.trim().equals("")) {
            return null;
        }
        if (urlNum == 1) {
            Tools.getSingleResult(source, method, include, an_include, result, addUrl);
        } else {
            String[] methods = null;
            String[] includes = null;
            String[] an_includes = null;
            if (method.indexOf("#") != -1) {
                methods = method.split("#");
            }
            if (include.indexOf("#") != -1) {
                includes = include.split("#");
            }
            if (an_include.indexOf("#") != -1) {
                an_includes = an_include.split("#");
            }
            if (includes != null && includes.length != urlNum) {
                includes = null;
            }
            if (an_includes != null && an_includes.length != urlNum) {
                an_includes = null;
            }
            if (methods != null && methods.length != urlNum) {
                methods = null;
            }
            int i = 0;
            while (i < urlNum) {
                Tools.getSingleResult(source, methods == null ? method : methods[i], includes == null ? include : includes[i], an_includes == null ? an_include : an_includes[i], result, addUrl);
                ++i;
            }
        }
        return result;
    }

    private static void getSingleResult(String source, String method, String include, String an_include, List<String> result, String addUrl) {
        String startMethod = "<" + method;
        String endMethod = "</" + method + ">";
        int firstMethod = source.indexOf(startMethod);
        int lastEndMethod = source.lastIndexOf(endMethod);
        if (firstMethod == -1 || lastEndMethod == -1) {
            endMethod = "/>";
        }
        lastEndMethod = source.lastIndexOf(endMethod);
        if (firstMethod == -1 || lastEndMethod == -1) {
            return;
        }
        String tem = source.substring(firstMethod);
        tem = tem.substring(0, tem.lastIndexOf(endMethod) + endMethod.length());
        while (tem.indexOf(startMethod) != -1 && tem.indexOf(endMethod) != -1) {
            String step = tem.substring(tem.indexOf(startMethod), tem.indexOf(endMethod) + endMethod.length());
            step = step.replaceAll("&amp;", "&");
            step = step.replaceAll("&", "&amp;");
            EpayLog.showSaveLog("last", step);
            String res = Tools.parser(new StringReader(step), method, include, an_include, addUrl);
            if (res != null && !res.trim().equals("")) {
                result.add(res);
            }
            tem = tem.substring(tem.indexOf(endMethod) + endMethod.length());
        }
    }

    private static String parser(StringReader sr, String method, String include, String an_include, String add_url) {
        XmlPullParser parser = Xml.newPullParser();
        StringBuffer str = new StringBuffer();
        String attribute = null;
        try {
            parser.setInput((Reader)sr);
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType != 0) {
                    if (eventType == 2) {
                        if (parser.getName().equals(method)) {
                            if (method.trim().equals("a")) {
                                attribute = "href";
                            } else if (method.trim().equals("card")) {
                                attribute = "ontimer";
                            } else if (method.trim().equals("go")) {
                                attribute = "href";
                            }
                            String attributeValue = parser.getAttributeValue(null, attribute);
                            String value = null;
                            try {
                                value = parser.nextText();
                            }
                            catch (Exception e) {
                                parser.next();
                            }
                            EpayLog.showSaveLog("====", "value is " + value + " , " + attribute + ",,," + attributeValue);
                            if (include != null && !include.trim().equals("") && !attributeValue.contains(include) || an_include != null && !an_include.trim().equals("") && (value == null || !value.contains(an_include))) break;
                            if (add_url != null && !add_url.trim().equals("")) {
                                attributeValue = String.valueOf(add_url) + attributeValue;
                            }
                            EpayLog.showSaveLog("last", "url is " + attributeValue + " , text is " + value);
                            str.append(attributeValue);
                        }
                    } else if (eventType != 3) {
                        // empty if block
                    }
                }
                eventType = parser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EpayLog.showSaveLog("\u89e3\u6790\u9519\u8bef", e.getMessage());
        }
        return str.toString();
    }

    public static String getURL(Context context, int whichOne) {
        int cpid = SystemInfo.getCpId(context);
        int service_id = SystemInfo.getServiceId(context);
        int fee = SystemInfo.getFee(context);
        String orderIdString = SystemInfo.getOrderId();
        String p = SystemInfo.getP(context);
        EpayLog.showSaveLog("====", "cpid is " + cpid + " , service_id is " + service_id + " , fee is " + fee + " , p is " + p);
        String smsc = new SMSCTools(context).dogetSMSC();
        String imsi = SystemInfo.getIMSI(context);
        String url = null;
        url = whichOne == 0 ? "http://epay.kdbooks.cn:8000" : "http://epay.d88g.com:8000";
        url = String.valueOf(url) + String.format("/payment?cpid=%s&appf_id=%s&paynum=%s&smsc=%s&cardid=%s&p=%s&order_id=%s", String.valueOf(cpid), String.valueOf(service_id), String.valueOf(fee), smsc, imsi, p, orderIdString, "1.1");
        return url;
    }

    public static String getConfirmURL(Context context, int whichOne, int confirmOrCancle) {
        int cpid = SystemInfo.getCpId(context);
        int service_id = SystemInfo.getServiceId(context);
        int fee = SystemInfo.getFee(context);
        String p = SystemInfo.getP(context);
        EpayLog.showSaveLog("====", "cpid is " + cpid + " , service_id is " + service_id + " , fee is " + fee + " , p is " + p);
        String smsc = new SMSCTools(context).dogetSMSC();
        String imsi = SystemInfo.getIMSI(context);
        String url = null;
        url = whichOne == 0 ? "http://epay.kdbooks.cn:8000" : "http://epay.d88g.com:8000";
        url = String.valueOf(url) + String.format("/status?cpid=%s&appf_id=%s&paynum=%s&smsc=%s&cardid=%s&p=%s&status=%s", String.valueOf(cpid), String.valueOf(service_id), String.valueOf(fee), smsc, imsi, p, String.valueOf(confirmOrCancle));
        return url;
    }

    public static String getFeddbackURL(Context context, int whichOne, int feeMode, int statue) {
        int cpid = SystemInfo.getCpId(context);
        int service_id = SystemInfo.getServiceId(context);
        int fee = SystemInfo.getFee(context);
        String p = SystemInfo.getP(context);
        EpayLog.showSaveLog("====", "cpid is " + cpid + " , service_id is " + service_id + " , fee is " + fee + " , p is " + p);
        String smsc = new SMSCTools(context).dogetSMSC();
        String imsi = SystemInfo.getIMSI(context);
        String url = null;
        url = whichOne == 0 ? "http://epay.kdbooks.cn:8000" : "http://epay.d88g.com:8000";
        url = String.valueOf(url) + String.format("/basestatus?cpid=%s&appfee_id=%s&fee_mode=%s&status=%s&smsc=%s&imsi=%s", String.valueOf(cpid), String.valueOf(service_id), String.valueOf(feeMode), String.valueOf(statue), smsc, imsi);
        return url;
    }

    public static Header[] getHeadersByDefault(Context context) {
        Header[] headers = new Header[8];
        BasicHeader mobile_model = new BasicHeader("mobile_model", Build.MODEL);
        headers[0] = mobile_model;
        BasicHeader os_version = new BasicHeader("os_version", String.valueOf(Build.VERSION.SDK_INT));
        headers[1] = os_version;
        BasicHeader net_mode = new BasicHeader("net_mode", SystemInfo.getNetworkInfo(context));
        headers[2] = net_mode;
        BasicHeader version_code = new BasicHeader("version_code", "1.1");
        headers[3] = version_code;
        BasicHeader packageName = new BasicHeader("package", SystemInfo.getPackageName(context));
        headers[4] = packageName;
        BasicHeader mobile = new BasicHeader("mobile", SystemInfo.getMobileNum(context));
        headers[5] = mobile;
        BasicHeader mobileClient = new BasicHeader("clientmobile", SystemInfo.getNativePhoneNumber(context));
        headers[6] = mobileClient;
        BasicHeader userid = new BasicHeader("u_id", SystemInfo.getUserIdFromDB(context));
        headers[7] = userid;
        return headers;
    }

    public static Header[] getHeadersByFeadback(Context context) {
        Header[] headers = new Header[8];
        BasicHeader mobile_model = new BasicHeader("mobile_model", Build.MODEL);
        headers[0] = mobile_model;
        BasicHeader os_version = new BasicHeader("os_version", String.valueOf(Build.VERSION.SDK_INT));
        headers[1] = os_version;
        BasicHeader net_mode = new BasicHeader("net_mode", SystemInfo.getNetworkInfo(context));
        headers[2] = net_mode;
        BasicHeader version_code = new BasicHeader("version_code", "1.1");
        headers[3] = version_code;
        BasicHeader packageName = new BasicHeader("package", SystemInfo.getPackageName(context));
        headers[4] = packageName;
        BasicHeader mobile = new BasicHeader("mobile", SystemInfo.getMobileNum(context));
        headers[5] = mobile;
        BasicHeader aurl = new BasicHeader("a_url", GameFee.currentWapUrl);
        headers[6] = aurl;
        BasicHeader mobileClient = new BasicHeader("clientmobile", SystemInfo.getNativePhoneNumber(context));
        headers[7] = mobileClient;
        return headers;
    }

    public static String getStringFromInputStream(InputStream input) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String tem = null;
        StringBuffer sb = new StringBuffer();
        try {
            while ((tem = reader.readLine()) != null) {
                sb.append(tem);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        EpayLog.showSaveLog("===", "\u534f\u8bae\u6570\u636e\u4e3a\uff1a" + sb.toString());
        return sb.toString();
    }

    private static void submitConfirm(final Context context, final int feeMode, final int statu) {
        new AsyncTask<String, String, String>(){

            protected String doInBackground(String ... params) {
                InputStream is = null;
                int i = 0;
                while (i < 6) {
                    String URL2 = Tools.getFeddbackURL(context, i / 3, feeMode, statu);
                    EpayLog.showSaveLog("====", URL2);
                    try {
                        is = Tools.getContentByCMWAP(URL2, Tools.getHeadersByFeadback(context), context).getEntity().getContent();
                        if (is != null) break;
                        Log.e((String)"===", (String)("\u4e0b\u8f7d\u5b8c\u6210\u53cd\u9988\uff1a" + is));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                return null;
            }
        }.execute((Object[])new String[]{""});
    }
}

