/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.wap;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.telephony.TelephonyManager;
import com.android.easou.epay.util.EpayLog;
import com.android.easou.epay.util.SystemInfo;
import com.android.easou.epay.util.WifiManage;

public class NetManage {
    public static String CMWAP = "cmwap";
    public static String CMNET = "cmnet";
    public static String GWAP_3 = "3gwap";
    public static String GNET_3 = "3gnet";
    public static String UNIWAP = "uniwap";
    public static String UNINET = "uninet";
    private Context context;
    private Uri PREFERRED_APN_URI;
    private Uri APN_TABLE_URI;
    private int creatNewApnId;
    private int cmwapApnId;
    private TelephonyManager tm;
    private int currentApnId;
    private int lastApnid;

    public NetManage(Context context) {
        this.context = context;
        this.PREFERRED_APN_URI = Uri.parse((String)"content://telephony/carriers/preferapn");
        this.APN_TABLE_URI = Uri.parse((String)"content://telephony/carriers");
    }

    private void showAPN(Cursor cursor) {
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String name = cursor.getString(cursor.getColumnIndex("name"));
                String numeric = cursor.getString(cursor.getColumnIndex("numeric"));
                String _id = cursor.getString(cursor.getColumnIndex("_id"));
                String mcc = cursor.getString(cursor.getColumnIndex("mcc"));
                String mnc = cursor.getString(cursor.getColumnIndex("mnc"));
                String apn = cursor.getString(cursor.getColumnIndex("apn"));
                String user = cursor.getString(cursor.getColumnIndex("user"));
                String server = cursor.getString(cursor.getColumnIndex("server"));
                String password = cursor.getString(cursor.getColumnIndex("password"));
                String proxy = cursor.getString(cursor.getColumnIndex("proxy"));
                String port = cursor.getString(cursor.getColumnIndex("port"));
                String mmsproxy = cursor.getString(cursor.getColumnIndex("mmsproxy"));
                String mmsport = cursor.getString(cursor.getColumnIndex("mmsport"));
                String mmsc = cursor.getString(cursor.getColumnIndex("mmsc"));
                String authtype = cursor.getString(cursor.getColumnIndex("authtype"));
                String type = cursor.getString(cursor.getColumnIndex("type"));
                String current = cursor.getString(cursor.getColumnIndex("current"));
                EpayLog.showSaveLog("AllWapAPN", "name=" + name + " numeric=" + numeric + " _id=" + _id + " mcc=" + mcc + " mnc=" + mnc + " apn=" + apn + " user=" + user + " server=" + server + " password=" + password + " proxy=" + proxy + " port=" + port + " mmsproxy=" + mmsproxy + " mmsport=" + mmsport + " mmsc=" + mmsc + " authtype=" + authtype + " type=" + type + " current=" + current);
            }
        }
    }

    public void showAllAPN() {
        Cursor cursor = this.context.getContentResolver().query(this.APN_TABLE_URI, null, "current='1'", null, null);
        this.showAPN(cursor);
    }

    public boolean isCurrentWapAPN() {
        block4: {
            String current;
            String port;
            String proxy;
            block5: {
                Cursor cursor = this.context.getContentResolver().query(this.PREFERRED_APN_URI, null, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                proxy = cursor.getString(cursor.getColumnIndex("proxy"));
                String apn = cursor.getString(cursor.getColumnIndex("apn"));
                port = cursor.getString(cursor.getColumnIndex("port"));
                current = cursor.getString(cursor.getColumnIndex("current"));
                this.currentApnId = cursor.getInt(cursor.getColumnIndex("_id"));
                EpayLog.showSaveLog("isCurrentWapAPN", "proxy=" + proxy + " , apn=" + apn + " port=" + port + " , current=" + current + " , _id=" + this.currentApnId);
                if (proxy != null && apn != null && port != null && current != null) break block5;
                return false;
            }
            try {
                if ((proxy.equals("10.0.0.172") || proxy.equals("010.000.000.172") || proxy.equals("10.0.0.200") || proxy.equals("010.000.000.200")) && port.equals("80") && current.equals("1")) {
                    EpayLog.showSaveLog("isCurrentWapAPN", "CurrentWapAPNd is cmwap");
                    return true;
                }
            }
            catch (Exception e) {
                EpayLog.showSaveLog("====", "\u8bfb\u53d6APN\u5931\u8d25");
            }
        }
        return false;
    }

    public int getCurrentWapAPNId() {
        Cursor cursor = this.context.getContentResolver().query(this.PREFERRED_APN_URI, null, null, null, null);
        this.showAPN(cursor);
        if (cursor != null && cursor.moveToFirst()) {
            this.currentApnId = cursor.getInt(cursor.getColumnIndex("_id"));
        }
        return this.currentApnId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkHasWapAPN() {
        try {
            int id;
            String apn;
            String current;
            String port;
            String proxy;
            String name;
            Cursor cursor = this.context.getContentResolver().query(this.APN_TABLE_URI, null, null, null, "_id ASC");
            do {
                if (cursor == null) return false;
                if (!cursor.moveToNext()) {
                    return false;
                }
                id = cursor.getInt(cursor.getColumnIndex("_id"));
                name = cursor.getString(cursor.getColumnIndex("name"));
                port = cursor.getString(cursor.getColumnIndex("port"));
                proxy = cursor.getString(cursor.getColumnIndex("proxy"));
                current = cursor.getString(cursor.getColumnIndex("current"));
                apn = cursor.getString(cursor.getColumnIndex("apn"));
            } while (name == null || proxy == null || port == null || current == null || apn == null || !proxy.equals("10.0.0.172") && !proxy.equals("010.000.000.172") && !proxy.equals("10.0.0.200") && !proxy.equals("010.000.000.200") || !port.equals("80") || !current.equals("1"));
            this.cmwapApnId = id;
            EpayLog.showSaveLog("checkHasWapAPN", "cmwapApnId=" + this.cmwapApnId);
            return true;
        }
        catch (Exception e) {
            EpayLog.showSaveLog("====", "\u8bfb\u53d6APN\u5931\u8d25" + e.getMessage());
        }
        return false;
    }

    public boolean setAPN(int id) {
        ContentValues values = new ContentValues();
        values.put("apn_id", Integer.valueOf(id));
        EpayLog.showSaveLog("", "\u5207\u6362APN " + id);
        try {
            this.context.getContentResolver().update(this.PREFERRED_APN_URI, values, null, null);
            this.currentApnId = id;
            return true;
        }
        catch (Exception e) {
            EpayLog.showSaveLog("===", "\u5207\u6362APN\u5931\u8d25");
            return false;
        }
    }

    public int addWapApn(Context context) {
        if (SystemInfo.getCardType(context).equals("mobile")) {
            return this.addCmwapAPN();
        }
        return 0;
    }

    public int addCmwapAPN() {
        ContentResolver cr = this.context.getContentResolver();
        ContentValues cv = new ContentValues();
        cv.put("name", "cmwap");
        cv.put("apn", "cmwap");
        cv.put("proxy", "10.0.0.172");
        cv.put("port", "80");
        this.tm = (TelephonyManager)this.context.getSystemService("phone");
        String imsi = this.tm.getSubscriberId();
        if (imsi != null && !imsi.trim().equals("")) {
            if (imsi.startsWith("46000")) {
                cv.put("numeric", "46000");
                cv.put("mcc", "460");
                cv.put("mnc", "00");
            } else if (imsi.startsWith("46002")) {
                cv.put("numeric", "46002");
                cv.put("mcc", "460");
                cv.put("mnc", "02");
            } else if (imsi.startsWith("46007")) {
                cv.put("numeric", "46007");
                cv.put("mcc", "460");
                cv.put("mnc", "07");
            } else {
                cv.put("numeric", imsi);
                cv.put("mcc", imsi.substring(0, 3));
                cv.put("mnc", imsi.substring(3));
            }
        }
        cv.put("mmsc", "http://mmsc.monternet.com");
        cv.put("mmsproxy", "10.0.0.172");
        cv.put("mmsport", "80");
        Cursor c = null;
        try {
            Uri newRow = cr.insert(this.APN_TABLE_URI, cv);
            if (newRow != null && (c = cr.query(newRow, null, null, null, null)) != null && c.moveToFirst()) {
                int id;
                this.creatNewApnId = id = c.getInt(c.getColumnIndex("_id"));
                if (this.setAPN(id)) {
                    this.cmwapApnId = id;
                } else {
                    id = 0;
                }
                c.close();
                int n = id;
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return 0;
    }

    public int addCtwapAPN() {
        ContentResolver cr = this.context.getContentResolver();
        ContentValues cv = new ContentValues();
        cv.put("name", "ctwap");
        cv.put("apn", "ctwap");
        cv.put("proxy", "10.0.0.200");
        cv.put("port", "80");
        this.tm = (TelephonyManager)this.context.getSystemService("phone");
        String imsi = this.tm.getSubscriberId();
        if (imsi != null && !imsi.trim().equals("")) {
            if (imsi.startsWith("46003")) {
                cv.put("numeric", "46003");
                cv.put("mcc", "460");
                cv.put("mnc", "03");
            } else if (imsi.startsWith("46005")) {
                cv.put("numeric", "46005");
                cv.put("mcc", "460");
                cv.put("mnc", "05");
            }
        }
        cv.put("mmsproxy", "10.0.0.200");
        cv.put("mmsport", "80");
        Cursor c = null;
        try {
            Uri newRow = cr.insert(this.APN_TABLE_URI, cv);
            if (newRow != null && (c = cr.query(newRow, null, null, null, null)) != null && c.moveToFirst()) {
                int id;
                this.creatNewApnId = id = c.getInt(c.getColumnIndex("_id"));
                if (this.setAPN(id)) {
                    this.cmwapApnId = id;
                } else {
                    id = 0;
                }
                c.close();
                int n = id;
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return 0;
    }

    public int addUniwapAPN() {
        ContentResolver cr = this.context.getContentResolver();
        ContentValues cv = new ContentValues();
        cv.put("name", "uniwap");
        cv.put("apn", "uniwap");
        cv.put("proxy", "10.0.0.172");
        cv.put("port", "80");
        this.tm = (TelephonyManager)this.context.getSystemService("phone");
        String imsi = this.tm.getSubscriberId();
        if (imsi != null && !imsi.trim().equals("")) {
            if (imsi.startsWith("46001")) {
                cv.put("numeric", "46001");
                cv.put("mcc", "460");
                cv.put("mnc", "01");
            } else if (imsi.startsWith("46006")) {
                cv.put("numeric", "46006");
                cv.put("mcc", "460");
                cv.put("mnc", "06");
            }
        }
        cv.put("mmsproxy", "10.0.0.172");
        cv.put("mmsport", "80");
        Cursor c = null;
        try {
            Uri newRow = cr.insert(this.APN_TABLE_URI, cv);
            if (newRow != null && (c = cr.query(newRow, null, null, null, null)) != null && c.moveToFirst()) {
                int id;
                this.creatNewApnId = id = c.getInt(c.getColumnIndex("_id"));
                if (this.setAPN(id)) {
                    this.cmwapApnId = id;
                } else {
                    id = 0;
                }
                c.close();
                int n = id;
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return 0;
    }

    public int getCmwapApnId() {
        return this.cmwapApnId;
    }

    public int getCurrentApnId() {
        return this.currentApnId;
    }

    public int getCreatNewApnId() {
        return this.creatNewApnId;
    }

    public void reSetLastApn() {
        if (this.lastApnid != 0) {
            this.setAPN(this.lastApnid);
            this.lastApnid = 0;
        }
    }

    public boolean setWapNetWork() {
        WifiManage wifiManage = new WifiManage(this.context);
        if (wifiManage.isWifiManageEnable()) {
            wifiManage.CloseWifi();
        }
        if (this.isCurrentWapAPN()) {
            EpayLog.showSaveLog("SetCMWAPActivity", "current is CMWAP!");
            return true;
        }
        this.lastApnid = this.getCurrentApnId();
        if (this.checkHasWapAPN()) {
            int cmwapid = this.getCmwapApnId();
            EpayLog.showSaveLog("SetCMWAPActivity", "checkHasWapAPN is true , cmwapid is " + cmwapid);
            return this.setAPN(cmwapid);
        }
        return this.addWapApn(this.context) != 0;
    }

    public boolean isDataConnected() {
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        int state = tm.getDataState();
        return state == 2;
    }
}

